//Source file: H:\middleware\src\Alkindi\Services\AlkExcept.java

package Alkindi.Services;

import java.io.*;

/* 
$Header: AlkExcept.java, 9, 1/2/01 3:39:11 PM, Schwartz, Joe$
$Log: 
 9    Alkindi Development1.8         1/2/01 3:39:11 PM    Schwartz, Joe   Added
      additional error info field & constructor which takes a Throwable
      parameter, form which a stack trace is taken and stored in the additional
      error info field.
 8    Alkindi Development1.7         12/28/00 12:34:53 PM Schwartz, Joe  
      Changed version control header info.
 7    Alkindi Development1.6         12/28/00 12:32:29 PM Schwartz, Joe   Added
      some more javadocs.
 6    Alkindi Development1.5         12/28/00 12:29:29 PM Schwartz, Joe  
      Testing version control keywords.
 5    Alkindi Development1.4         12/26/00 6:57:09 PM  Schwartz, Joe   
 4    Alkindi Development1.3         11/20/00 10:52:33 PM Schwartz, Joe   
 3    Alkindi Development1.2         11/11/00 4:58:19 PM  Schwartz, Joe  
      Chagned to use MyList management classes.
 2    Alkindi Development1.1         10/19/00 1:12:03 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 1    Alkindi Development1.0         10/6/00 4:14:16 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Custom exception class for Business Services.
 */
public class AlkExcept extends Exception 
{
	
	/**
	 * Stores additional error information.
	 */
	private String addlErrInfo = null;
	private int errNum = 0;
	
	public AlkExcept() 
	{
	}
	
	/**
	 * @param msg The error message to use.
	 * @param code A code number for the error.
	 * @roseuid 39D2271D01D4
	 */
	public AlkExcept(final String msg, final int code) 
	{
		super (msg);
		errNum = code;
	}
	
	/**
	 * This constuctor stores the same information as the 2-argument version, but also stores the information contained in the given Throwable object. Namely, it takes the stack trace of <pre>error</pre>and stores it as a string. This information can be accessed via the toString() method.
	 * @param msg The error message to use.
	 * @param code A code number for the error.
	 * @param error The Exception whose information should be stored within this AlkExcept.
	 * @roseuid 3A520D590271
	 */
	public AlkExcept(final java.lang.String msg, final int code, final java.lang.Throwable error) 
	{
		super(msg);
		errNum = code;
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		error.printStackTrace(pw);
		addlErrInfo = sw.toString();
	}
	
	/**
	 * @roseuid 39D226FB0242
	 */
	public int errCode() 
	{
		return errNum;
	}
	
	/**
	 * @roseuid 3A187F3202CE
	 */
	public String toString() 
	{
		String strRet = "AlkExcept: Code " + Integer.toString(errNum) + ' ' + getMessage();
		if (addlErrInfo != null) 
			strRet +=  "\nService Stack Trace:\n" + addlErrInfo;
		return strRet;
	}
}
